<?php
/**
 * Creative Elements - live Theme & Page Builder
 *
 * @author    WebshopWorks
 * @copyright 2019-2023 WebshopWorks.com
 * @license   One domain support license
 */

namespace CE;

defined('_PS_VERSION_') or exit;

use CE\CoreXBaseXModule as BaseModule;
use CE\ModulesXCatalogXControlsXSelectCategory as SelectCategory;
use CE\ModulesXCatalogXControlsXSelectManufacturer as SelectManufacturer;
use CE\ModulesXCatalogXControlsXSelectSupplier as SelectSupplier;
use CE\ModulesXCatalogXDocumentsXProduct as ProductDocument;

class ModulesXCatalogXModule extends BaseModule
{
    public function getName()
    {
        return 'catalog';
    }

    public function registerControls($controls_manager)
    {
        $controls_manager->registerControl(SelectCategory::CONTROL_TYPE, new SelectCategory());
        $controls_manager->registerControl(SelectManufacturer::CONTROL_TYPE, new SelectManufacturer());
        $controls_manager->registerControl(SelectSupplier::CONTROL_TYPE, new SelectSupplier());
    }

    public function registerTags($dynamic_tags)
    {
        $class_prefix = 'CE\ModulesXCatalogXTagsX';

        $dynamic_tags->registerTag($class_prefix . 'ProductAddToCart');
        $dynamic_tags->registerTag($class_prefix . 'ProductBuyNow');
        $dynamic_tags->registerTag($class_prefix . 'ProductQuickView');
        $dynamic_tags->registerTag($class_prefix . 'ProductImages');
        $dynamic_tags->registerTag($class_prefix . 'CategoryImages');
        $dynamic_tags->registerTag($class_prefix . 'ManufacturerImages');
        $dynamic_tags->registerTag($class_prefix . 'CartRuleDateTime');
        $dynamic_tags->registerTag($class_prefix . 'SpecificPriceRuleDateTime');
    }

    private function refreshProduct($content)
    {
        $context = \Context::getContext();
        $id_product = (int) \Tools::getValue('id_product');
        $groups = \Tools::getValue('group');
        $ipa = $groups ? (int) \Product::getIdProductAttributeByIdAttributes($id_product, $groups, true) : null;
        $product = new \Product($id_product, false, $context->language->id, $context->shop->id);
        $product_url = $context->link->getProductLink($product, null, null, null, null, null, $ipa, false, false, true);
        $args = ${'_GET'};
        unset(
            $args['controller'],
            $args['action'],
            $args['id_product'],
            $args['id_product_attribute'],
            $args['rewrite'],
            $args['isolang'],
            $args['id_lang']
        );
        header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');

        wp_send_json([
            'product_content' => &$content,
            'product_url' => $args
                ? str_replace('#', (strpos('?', $product_url) === false ? '?' : '&') . http_build_query($args) . '#', $product_url)
                : $product_url,
            'product_minimal_quantity' => (int) \Closure::bind(function () use ($ipa) {
                return $this->getProductMinimalQuantity(['id_product_attribute' => $ipa]);
            }, $context->controller, $context->controller)->__invoke(),
            'id_product_attribute' => $ipa,
            'product_title' => $product->name,
            'is_quick_view' => \Tools::getValue('quickview'),
        ]);
    }

    public function init()
    {
        $context = \Context::getContext();
        // Init Quick View
        if ($id_pqv = (int) \Configuration::get('CE_PRODUCT_QUICK_VIEW')) {
            Plugin::$instance->frontend->hasElementorInPage(true);

            if ($context->controller instanceof \ProductController && \Tools::getValue('action') === 'quickview') {
                \CreativeElements::skipOverrideLayoutTemplate();

                $context->smarty->assign('CE_PRODUCT_QUICK_VIEW_ID', $id_pqv);

                UId::$_ID = new UId($id_pqv, UId::THEME, $context->language->id, $context->shop->id);
            }
        }
        // Init Product Refresh
        if ($context->controller instanceof \ProductController && \Tools::getValue('action') === 'refresh' &&
            $id_ce_theme = \Configuration::get(empty($_REQUEST['quickview']) ? 'CE_PRODUCT' : 'CE_PRODUCT_QUICK_VIEW')
        ) {
            add_action('elementor/widgets/widgets_registered', function ($manager) {
                // Skip these widgets on refresh
                $manager->unregisterWidgetType('product-name');
                $manager->unregisterWidgetType('product-description');
                $manager->unregisterWidgetType('product-description-short');
                $manager->unregisterWidgetType('product-quantity');
                $manager->unregisterWidgetType('product-box');
                $manager->unregisterWidgetType('product-grid');
                $manager->unregisterWidgetType('product-carousel');
            }, 11);

            $this->refreshProduct(\CreativeElements::renderTheme(
                new UId($id_ce_theme, UId::THEME, $context->language->id, $context->shop->id)
            ));
        }
    }

    public function __construct()
    {
        add_action('template_redirect', [$this, 'init'], 1);
        add_action('elementor/controls/controls_registered', [$this, 'registerControls']);
        add_action('elementor/dynamic_tags/register_tags', [$this, 'registerTags']);
        add_action('ce/css-file/global/before_render', function () {
            // Init widgets if needed
            $widgets_manager = Plugin::$instance->widgets_manager;
            $widgets_manager->getWidgetTypes();

            ProductDocument::registerWidgets($widgets_manager);
        });
    }
}
