Changelog for Stripe Connector
===

3.2.1
---

* _FIXED_ Unable to upgrade to 3.2.0 because of SQL

3.2.0
---

* _ADDED_ Implement new translation system
* _ADDED_ Use PrestaShop native table for logs
* _ADDED_ Implement new UI
* _CHANGED_ Order creation and webhook handler rewrite
* _CHANGED_ Use one webhook for multistore

3.1.4
---

* _ADDED_ - Pin API Version
* _FIXED_ - Remove Sofort references
* _FIXED_ - Fixed Link payment with 3DS
* _FIXED_ - Fixed publishableKey check
* _CHANGED_ Format logs and exceptions

3.1.3
---

* _ADDED_ - Remove redundant error messages
* _FIXED_ - Initialize Stripe library on selecting payment method
* _CHANGED_ Text changes

3.1.2
---

* _CHANGED_ Text changes
* _FIXED_ - Error on confirming payment intents

3.1.1
---

* _FIXED_ - Idempotency error on customer creation
* _FIXED_ - Moment of order creation
* _FIXED_ - Synchronization for statuses for some payment methods: sepa_debit and sofort
* _ADDED_ - Support for new status PENDING
* _FIXED_ - Charge object retrieval for new Stripe api version

3.1.0
---

* _FIXED_ - Duplicate payments
* _FIXED_ - Order creation and update
* _ADDED_ - Streamlined payment flows
* _FIXED_ - Reduced JS dependencies
* _FIXED_ - Multishop with one Stripe account
* _FIXED_ - Multishop with multiple Stripe accounts
* _FIXED_ - Idempotent requests
* _ADDED_ - Pass default values to payment elements
* _FIXED_ - Webhook response codes

3.0.5
---

* _FIXED_ - Security audit issues


3.0.4
---

* _FIXED_ - Payment error when you change from payment element to checkout flow mid payment
* _ADDED_ - Missing translations for de, es, fr, it
* _FIXED_ - Translations for checkout flow
* _FIXED_ - JS errors on checkout page
* _FIXED_ - Saving api keys when switching between live and test mode
* _FIXED_ - Saving webhook configs when switching between live and test mode


3.0.3
---

* _FIXED_ Payment is not showing an order in Prestashop
* _FIXED_ Duplicate payments in Stripe Dashboard
* _FIXED_ Checkout Session back button error
* _FIXED_ Add Order ID to Description in Stripe Payments
* _FIXED_ Make disabled Place Order button after one click
* _CHANGED_ Version

3.0.2
---

* _FIXED_ amount not calculated correctly on checkout
* _FIXED_ javascript interferrence on older PS versions
* _FIXED_ json decoding information for payment intent
* _FIXED_ payment element initialization on older PS versions
* _FIXED_ logger errors on Stripe Customer
* _FIXED_ incompatibility issues with PS version newer than 8.0.0
* _FIXED_ specific compatibility issues for PS version 8.0.3
* _FIXED_ user not able to save live keys
* _CHANGED_ Version

3.0.1
---

* _FIXED_ Plugin interacting and breaking css on checkout
* _FIXED_ Plugin interacting and breaking other plugins/payment methods
* _CHANGED_ Version

3.0.0
---

* _FIXED_ Remove beta flags
* _CHANGED_ Version

3.0.0-RC2
---

* _FIXED_ Billing Details are not used to render Payment Elements
* _FIXED_ When using Stripe Checkout, the total amount does not include VAT
* _FIXED_ Send billing details when rendering payment elements
* _FIXED_ "Do not collect zip code" is working now
* _FIXED_ Checkout and Payment Element are displayed in the wrong locale
* _FIXED_ Refund page problem, where we got a blank page instead of an error
* _FIXED_ Full/Partial Refund status syncing
* _FIXED_ Missing images for payment methods
* _FIXED_ Caching issue
* _FIXED_ Rename the "Payment form settings" option
* _FIXED_ SEPA doesn't capture automatically
* _FIXED_ Text and asterisk corrections on Prestashop backoffice
* _FIXED_ Cancel Payment Sync between Stripe dashboard and Prestashop backoffice
* _FIXED_ Checkout error on successful transactions
* _FIXED_ Payment Error status on Prestashop backoffice
* _FIXED_ Remove shipping and product details and only send total amount with checkout
* _FIXED_ Do not filter payment methods when separate auth and capture is activated
* _FIXED_ 3D Secure 'Cancel' button redirect to correct page
* _ADDED_ Style Payment Element from back office

3.0.0-RC1
---

* _ADDED_ Billing and delivery details sent when creating a checkout session
* _ADDED_ Decouple Payment Intent creation and Payment Element rendering
* _ADDED_ Fraud and payment data with OMS sync
* _FIXED_ Capture option in backoffice			
* _FIXED_ Remove 'Save customer cards' option	
* _ADDED_ Radio button for both Payment Elements and Stripe Checkout		
* _FIXED_ Remove "Collect client name" option in connector options	
* _FIXED_ Customers are not created in stripe dashboard	
* _FIXED_ Remove the option for Google Pay and Apple Pay from the backoffice
* _FIXED_ Fix the current refund implementation	
* _FIXED_ Removing support from PrestaShop 1.6		
* _ADDED_ Payments with Payment Element	
* _ADDED_ Payments with Stripe Checkout	
* _ADDED_ Simultaneous auth and capture with OMS sync		
* _ADDED_ Separate auth and capture with OMS sync
