<?php
/**
 * Copyright (c) since 2010 Stripe, Inc. (https://stripe.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    Stripe <https://support.stripe.com/contact/email>
 * @copyright Since 2010 Stripe, Inc.
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class AddressModel
{
    public $city;
    public $countryIso;
    public $street;
    public $zipCode;
    public $state;

    public function __construct($psAddress, $psState, $psCountryIso)
    {
        $this->city = $psAddress->city ?: null;
        $this->countryIso = $psCountryIso ?: null;
        $this->street = $psAddress->address1 ?: null;
        $this->zipCode = $psAddress->postcode ?: null;
        $this->state = $psState->iso_code ?: null;
    }

    public static function getFromContext($context): self
    {
        $psAddress = new Address($context->cart->id_address_delivery);
        $psState = new State($psAddress->id_state);
        $psCountryIso = Country::getIsoById($psAddress->id_country);

        return new self($psAddress, $psState, $psCountryIso);
    }

    public function __serialize()
    {
        return [
            'city' => $this->city,
            'country' => $this->countryIso,
            'line1' => $this->street,
            'postal_code' => $this->zipCode,
            'state' => $this->state,
        ];
    }
}
