<?php
/**
 * Copyright (c) since 2010 Stripe, Inc. (https://stripe.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License version 3.0
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    Stripe <https://support.stripe.com/contact/email>
 * @copyright Since 2010 Stripe, Inc.
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License version 3.0
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class CustomerModel
{
    public $email;
    public $name;
    public $id;
    public $address;

    /**
     * @param Customer $customer
     * @param AddressModel $addressModel
     */
    public function __construct($psCustomer, $addressModel)
    {
        $this->name = $psCustomer->firstname . ' ' . $psCustomer->lastname ?: null;
        $this->email = $psCustomer->email ?: null;
        $this->id = $psCustomer->id ?: null;
        $this->address = $addressModel;
    }

    public static function getFromContext($context): self
    {
        $addressModel = AddressModel::getFromContext($context);
        $psCustomer = $context->customer;

        return new self($psCustomer, $addressModel);
    }

    public function __serialize(): array
    {
        return [
            'email' => $this->email,
            'name' => $this->name,
            'id' => $this->id,
            'address' => $this->address->__serialize(),
        ];
    }
}
